/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures;

import Data_Structures.ADTs.BST;
import Data_Structures.ADTs.Queue;
import Data_Structures.ADTs.Sets.SimpleSet;
import Data_Structures.ADTs.Stack;
import Data_Structures.Operations.Sort;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.Fast.FastQueue;
import Data_Structures.Structures.Fast.FastStack;
import Data_Structures.Structures.Fast.FastStructure;
import Data_Structures.Structures.HashTable;
import Data_Structures.Structures.HashingClasses.Dict;
import Data_Structures.Structures.HashingClasses.Set;
import Data_Structures.Structures.InDevelopment.Heaps.ArrayHeap;
import Data_Structures.Structures.InDevelopment.Trees.AVL;
import Data_Structures.Structures.InDevelopment.Trees.Treap;
import Data_Structures.Structures.InDevelopment.UnionFind;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.List;
import Data_Structures.Structures.SingleLinkedList;
import Data_Structures.Structures.UBA;
import java.util.Iterator;
import util.Genarics;
import util.Print;
import util.testing;

public class aatesting {
    private final int TEST_SIZE = 1000;
    private static Genarics<Data_Structure<?>> ge_ds = new Genarics();

    public aatesting() {
        this.test_List();
        this.test_UBA();
        this.test_HashTable();
        this.test_AssociativeArrays();
        this.test_set();
        this.test_sort_and_search();
        this.test_Trees();
        this.test_singleLinkedList();
        this.test_set(new AVL<Integer>());
        this.test_set(new HashTable<Integer>());
        this.test_fast_structures();
        this.test_heap();
        this.test_UnionFind();
        this.test_Treap();
        Print.print("All Tests Passed!");
    }

    private void test_Treap() {
        Treap<Integer> T_EMPTY = new Treap<Integer>();
        this.Tree_Empty(T_EMPTY);
        BST T_LEAF0 = T_EMPTY.add_static((Comparable)Integer.valueOf(0));
        this.Tree_Leaf0((Treap<Integer>)T_LEAF0);
        this.Tree_Empty(T_EMPTY);
        Treap<Integer> T = T_EMPTY;
        T = T.add_static(0, 3);
        T = T.add_static(-2, 2);
        T = T.add_static(2, 2);
        T = T.add_static(-1, 1);
        T = T.add_static(1, 1);
        testing.ASSERT(T.isTreap());
        testing.ASSERT(T.contains(0));
        testing.ASSERT(T.contains(-2));
        testing.ASSERT(T.contains(2));
        testing.ASSERT(T.contains(-1));
        testing.ASSERT(T.contains(1));
        testing.ASSERT(!T.contains(100));
        BST T2 = T.remove_static((Comparable)Integer.valueOf(100));
        testing.ASSERT(((Treap)T2).isTreap());
        testing.ASSERT(((Treap)T2).contains(0));
        testing.ASSERT(((Treap)T2).contains(-2));
        testing.ASSERT(((Treap)T2).contains(2));
        testing.ASSERT(((Treap)T2).contains(-1));
        testing.ASSERT(((Treap)T2).contains(1));
        T2 = T.remove_static((Comparable)Integer.valueOf(1));
        testing.ASSERT(((Treap)T2).isTreap());
        testing.ASSERT(((Treap)T2).contains(0));
        testing.ASSERT(((Treap)T2).contains(-2));
        testing.ASSERT(((Treap)T2).contains(2));
        testing.ASSERT(((Treap)T2).contains(-1));
        testing.ASSERT(!((Treap)T2).contains(1));
        T2 = T.remove_static((Comparable)Integer.valueOf(-1));
        testing.ASSERT(((Treap)T2).isTreap());
        testing.ASSERT(((Treap)T2).contains(0));
        testing.ASSERT(((Treap)T2).contains(-2));
        testing.ASSERT(((Treap)T2).contains(2));
        testing.ASSERT(!((Treap)T2).contains(-1));
        testing.ASSERT(((Treap)T2).contains(1));
        T2 = T.remove_static((Comparable)Integer.valueOf(-2));
        testing.ASSERT(((Treap)T2).isTreap());
        testing.ASSERT(((Treap)T2).contains(0));
        testing.ASSERT(!((Treap)T2).contains(-2));
        testing.ASSERT(((Treap)T2).contains(2));
        testing.ASSERT(((Treap)T2).contains(-1));
        testing.ASSERT(((Treap)T2).contains(1));
        T2 = T.remove_static((Comparable)Integer.valueOf(2));
        testing.ASSERT(((Treap)T2).isTreap());
        testing.ASSERT(((Treap)T2).contains(0));
        testing.ASSERT(((Treap)T2).contains(-2));
        testing.ASSERT(!((Treap)T2).contains(2));
        testing.ASSERT(((Treap)T2).contains(-1));
        testing.ASSERT(((Treap)T2).contains(1));
        T2 = T.remove_static((Comparable)Integer.valueOf(0));
        testing.ASSERT(((Treap)T2).isTreap());
        testing.ASSERT(!((Treap)T2).contains(0));
        testing.ASSERT(((Treap)T2).contains(-2));
        testing.ASSERT(((Treap)T2).contains(2));
        testing.ASSERT(((Treap)T2).contains(-1));
        testing.ASSERT(((Treap)T2).contains(1));
        BST T_Current = T_EMPTY;
        T_Current = ((Treap)T_Current).add_static(0, 0);
        T_Current = ((Treap)T_Current).add_static(1, -1);
        T_Current = ((Treap)T_Current).add_static(2, 1);
        testing.ASSERT(((Treap)T_Current).isTreap());
        T_Current = T_EMPTY;
        BST T_last = T_Current;
        this.Tree_Empty(T_EMPTY);
        int i = 0;
        while (i < 1000) {
            testing.ASSERT(!T_last.contains(i));
            T_Current = T_last.add_static(Integer.valueOf(i));
            testing.ASSERT(((Treap)T_Current).isTreap());
            testing.ASSERT(((Treap)T_Current).contains(i));
            testing.ASSERT(!T_last.contains(i));
            T_last = T_Current;
            ++i;
        }
        i = 999;
        while (i >= 0) {
            testing.ASSERT(T_last.contains(i));
            T_Current = T_last.remove_static(Integer.valueOf(i));
            testing.ASSERT(((Treap)T_Current).isTreap());
            testing.ASSERT(!((Treap)T_Current).contains(i));
            testing.ASSERT(T_last.contains(i));
            T_last = T_Current;
            --i;
        }
        testing.ASSERT(((Treap)T_Current).remove_static(Integer.valueOf(5)) == T_Current);
        testing.ASSERT(((Treap)T_Current).remove_static(Integer.valueOf(0)) == T_Current);
        throw new Error("split, merge, etc have not yet been tested");
    }

    private void Tree_Empty(Treap<Integer> T) {
        testing.ASSERT(T.isEmpty());
        testing.ASSERT(T.isTreap());
    }

    private void Tree_Leaf0(Treap<Integer> T) {
        testing.ASSERT(T.isLeaf());
        testing.ASSERT(!T.isEmpty());
        testing.ASSERT(T.contains(0));
        testing.ASSERT(!T.contains(1));
        testing.ASSERT(T.isTreap());
    }

    private void test_List() {
        List<Object> L = new List<Integer>();
        testing.ASSERT(L.isEmpty());
        testing.ASSERT(L.size() == 0);
        Integer[] A = new Integer[1000];
        int i = 0;
        while (i < 1000) {
            L.add(i);
            A[i] = i;
            testing.ASSERT((Integer)L.getFirst() == 0);
            testing.ASSERT(i == (Integer)L.getLast());
            testing.ASSERT(L.size() == i + 1);
            testing.ASSERT(!L.isEmpty());
            ++i;
        }
        Integer[] LA = (Integer[])L.toArray();
        testing.ASSERT(LA != null);
        testing.ASSERT(L.size() == 1000);
        testing.ASSERT(this.equal(LA, A));
        int i2 = 999;
        while (i2 >= 0) {
            testing.ASSERT(i2 == (Integer)L.getLast());
            testing.ASSERT((Integer)L.getFirst() == 0);
            testing.ASSERT(!L.isEmpty());
            testing.ASSERT(((Integer)L.rem()).equals(i2));
            testing.ASSERT(i2 == L.size());
            --i2;
        }
        testing.ASSERT(L.isEmpty() && L.size() == 0);
        Iterator iterator = L.iterator();
        if (iterator.hasNext()) {
            Integer i3 = (Integer)iterator.next();
            i3 = i3 + 1;
            throw new Error("There should not be any iteration in an empty list.");
        }
        i2 = 0;
        while (i2 < 1000) {
            L.push(i2);
            A[i2] = i2;
            testing.ASSERT((Integer)L.getFirst() == 0);
            testing.ASSERT(i2 == (Integer)L.getLast());
            testing.ASSERT(L.size() == i2 + 1);
            testing.ASSERT(!L.isEmpty());
            ++i2;
        }
        LA = (Integer[])L.toArray();
        testing.ASSERT(LA != null);
        testing.ASSERT(L.size() == 1000);
        testing.ASSERT(this.equal(LA, A));
        i2 = 999;
        while (i2 >= 0) {
            testing.ASSERT(i2 == (Integer)L.getLast());
            testing.ASSERT((Integer)L.getFirst() == 0);
            testing.ASSERT(!L.isEmpty());
            testing.ASSERT(((Integer)L.pop()).equals(i2));
            testing.ASSERT(i2 == L.size());
            --i2;
        }
        testing.ASSERT(L.isEmpty() && L.size() == 0);
        i2 = 0;
        while (i2 < 1000) {
            L.enq(i2);
            A[i2] = i2;
            testing.ASSERT((Integer)L.getFirst() == 0);
            testing.ASSERT(i2 == (Integer)L.getLast());
            testing.ASSERT(L.size() == i2 + 1);
            testing.ASSERT(!L.isEmpty());
            ++i2;
        }
        LA = (Integer[])L.toArray();
        testing.ASSERT(LA != null);
        testing.ASSERT(L.size() == 1000);
        testing.ASSERT(this.equal(LA, A));
        i2 = 0;
        while (i2 < 1000) {
            testing.ASSERT(999 == (Integer)L.getLast());
            testing.ASSERT(i2 == (Integer)L.getFirst());
            testing.ASSERT(!L.isEmpty());
            testing.ASSERT(((Integer)L.deq()).equals(i2));
            testing.ASSERT(999 - i2 == L.size());
            ++i2;
        }
        testing.ASSERT(L.isEmpty() && L.size() == 0);
        i2 = 0;
        while (i2 < 1000) {
            L.add(i2);
            ++i2;
        }
        List<Integer> L2 = L.clone();
        A = (Integer[])L.toArray();
        Integer[] A2 = (Integer[])L2.toArray();
        testing.ASSERT(this.equal(A, A2));
        testing.ASSERT(A != A2);
        testing.ASSERT(L.equals(L2));
        L.add(13);
        L2.add(13);
        testing.ASSERT(L.equals(L2));
        L.rem();
        L2 = new List<Integer>();
        testing.ASSERT(L2.isEmpty());
        testing.ASSERT(!L.equals(L2));
        L2.append((Data_Structure<Integer>)L);
        testing.ASSERT(L.equals(L2));
        A = new Integer[]{5, 4, 3};
        L.append(A);
        L2.add(5);
        L2.add(4);
        L2.add(3);
        testing.ASSERT(L.equals(L2));
        L = new List();
        int i4 = 0;
        while (i4 < 1000) {
            L.push(i4);
            ++i4;
        }
        i4 = 0;
        while (i4 < 1000) {
            testing.ASSERT(L.contains(i4));
            ++i4;
        }
        i4 = 0;
        Iterator iter2 = L.iterator();
        IterB iter22 = L.getIter();
        while (iter2.hasNext()) {
            testing.ASSERT(i4 == (Integer)iter2.next());
            ++i4;
        }
        i4 = 0;
        while (iter22.hasNext()) {
            testing.ASSERT(i4 == (Integer)iter22.next());
            ++i4;
        }
        i4 = 999;
        IterB iter_backwards = L.getTailIter();
        while (iter_backwards.hasPrevious()) {
            testing.ASSERT(i4 == (Integer)iter_backwards.previous());
            --i4;
        }
        L = new List();
        iter2 = L.iterator();
        iter22 = L.getIter();
        iter_backwards = L.getTailIter();
        testing.ASSERT(L.isEmpty());
        testing.ASSERT(!iter2.hasNext() && !iter22.hasNext());
        testing.ASSERT(!iter_backwards.hasNext() && !iter_backwards.hasPrevious());
        i4 = 0;
        while (i4 < 1000) {
            L.add((int)(Math.random() * 1000.0));
            ++i4;
        }
        L.sort();
        A = (Integer[])L.toArray();
        testing.ASSERT(this.isSorted(A));
        Integer[] A3 = new Integer[]{5, 7, 23, 8, 4, 7, 4};
        L = new List<Integer>(A3);
        testing.ASSERT(this.equal((Integer[])L.toArray(), A3));
        L = new List<Integer>(5, 7, 23, 8, 4, 7, 4);
        testing.ASSERT(this.equal((Integer[])L.toArray(), A3));
        L = new List<Integer>(1, 2);
        IterB<Object> iter3 = L.getIter();
        testing.ASSERT(iter3.hasNext());
        testing.ASSERT((Integer)iter3.next() == 1);
        testing.ASSERT(!iter3.hasPrevious());
        iter3.insertBefore(0);
        testing.ASSERT((Integer)iter3.current() == 0);
        testing.ASSERT(!iter3.hasPrevious() && (Integer)L.getFirst() == 0);
        testing.ASSERT(iter3.hasNext());
        testing.ASSERT((Integer)iter3.next() == 1);
        testing.ASSERT((Integer)iter3.current() == 1);
        iter3.replace(9);
        testing.ASSERT((Integer)iter3.current() == 9 && iter3.hasPrevious() && iter3.hasNext());
        testing.ASSERT((Integer)iter3.previous() == 0);
        iter3.next();
        testing.ASSERT((Integer)iter3.next() == 2);
        iter3.insertAfter(10);
        testing.ASSERT((Integer)iter3.current() == 10 && !iter3.hasNext() && iter3.hasPrevious());
        testing.ASSERT((Integer)L.getLast() == 10);
        testing.ASSERT((Integer)iter3.previous() == 2);
        testing.ASSERT((Integer)iter3.next() == 10);
        iter3.remove();
        testing.ASSERT(iter3.current() == null);
        testing.ASSERT(!iter3.hasNext() && iter3.hasPrevious());
        testing.ASSERT((Integer)iter3.previous() == 2);
        L.clear();
        testing.ASSERT(L.isEmpty());
        iter3 = L.getIter();
        testing.ASSERT(!iter3.hasNext());
        iter2 = L.getTailIter();
        testing.ASSERT(!iter2.hasNext());
        L = new List<Integer>(1, 2, 3, 4, 5, 6, 7, 8, 9);
        L.reverse();
        Integer[] A4 = new Integer[]{9, 8, 7, 6, 5, 4, 3, 2, 1};
        testing.ASSERT(this.equal((Integer[])L.toArray(), A4));
        L.remove(4);
        L.remove(9);
        L.remove(1);
        L.remove(3);
        Integer[] A5 = new Integer[]{8, 7, 6, 5, 2};
        testing.ASSERT(this.equal((Integer[])L.toArray(), A5));
        L = new List<Integer>(1, 2, 3, 4);
        L2 = new List<Integer>(5, 6, 7);
        L.destructiveAppend(L2);
        testing.ASSERT(L.size() == 7);
        testing.ASSERT((Integer)L.getFirst() == 1);
        testing.ASSERT((Integer)L.getLast() == 7);
        L = new List();
        L2 = new List<Integer>(1, 2, 3);
        L.destructiveAppend(L2);
        testing.ASSERT(L.size() == 3);
        testing.ASSERT((Integer)L.getFirst() == 1);
        testing.ASSERT((Integer)L.getLast() == 3);
        L = new List<Integer>(1, 2, 3);
        L2 = new List();
        L.destructiveAppend(L2);
        testing.ASSERT(L.size() == 3);
        testing.ASSERT((Integer)L.getFirst() == 1);
        testing.ASSERT((Integer)L.getLast() == 3);
    }

    private void test_UBA() {
        UBA<Integer> uba = new UBA<Integer>(1);
        testing.ASSERT(uba.isEmpty());
        testing.ASSERT(uba.size() == 0);
        Integer[] A = new Integer[1000];
        int i = 0;
        while (i < 1000) {
            uba.add(i);
            A[i] = i;
            testing.ASSERT((Integer)uba.getFirst() == 0);
            testing.ASSERT(i == (Integer)uba.getLast());
            testing.ASSERT(uba.size() == i + 1);
            testing.ASSERT(!uba.isEmpty());
            ++i;
        }
        Integer[] uba_a = (Integer[])uba.toArray();
        testing.ASSERT(uba_a != null);
        testing.ASSERT(uba.size() == 1000);
        testing.ASSERT(this.equal(uba_a, A));
        int i2 = 999;
        while (i2 >= 0) {
            testing.ASSERT(i2 == (Integer)uba.getLast());
            testing.ASSERT((Integer)uba.getFirst() == 0);
            testing.ASSERT(!uba.isEmpty());
            testing.ASSERT(((Integer)uba.rem()).equals(i2));
            testing.ASSERT(i2 == uba.size());
            --i2;
        }
        testing.ASSERT(uba.isEmpty() && uba.size() == 0);
        uba = new UBA(50);
        i2 = 0;
        while (i2 < 1000) {
            uba.push(i2);
            A[i2] = i2;
            testing.ASSERT((Integer)uba.getFirst() == 0);
            testing.ASSERT(i2 == (Integer)uba.getLast());
            testing.ASSERT(uba.size() == i2 + 1);
            testing.ASSERT(!uba.isEmpty());
            ++i2;
        }
        uba_a = (Integer[])uba.toArray();
        testing.ASSERT(uba_a != null);
        testing.ASSERT(uba.size() == 1000);
        testing.ASSERT(this.equal(uba_a, A));
        i2 = 999;
        while (i2 >= 0) {
            testing.ASSERT(i2 == (Integer)uba.getLast());
            testing.ASSERT((Integer)uba.getFirst() == 0);
            testing.ASSERT(!uba.isEmpty());
            testing.ASSERT(((Integer)uba.pop()).equals(i2));
            testing.ASSERT(i2 == uba.size());
            --i2;
        }
        testing.ASSERT(uba.isEmpty() && uba.size() == 0);
        i2 = 0;
        while (i2 < 1000) {
            uba.enq(i2);
            A[i2] = i2;
            testing.ASSERT((Integer)uba.getFirst() == 0);
            testing.ASSERT(i2 == (Integer)uba.getLast());
            testing.ASSERT(uba.size() == i2 + 1);
            testing.ASSERT(!uba.isEmpty());
            ++i2;
        }
        uba_a = (Integer[])uba.toArray();
        testing.ASSERT(uba_a != null);
        testing.ASSERT(uba.size() == 1000);
        testing.ASSERT(this.equal(uba_a, A));
        testing.ASSERT(uba != null);
        i2 = 0;
        while (i2 < 1000) {
            if (uba.getLast() == null) {
                Print.print(i2);
                Print.print(uba);
            }
            testing.ASSERT(999 == (Integer)uba.getLast());
            testing.ASSERT(i2 == (Integer)uba.getFirst());
            testing.ASSERT(!uba.isEmpty());
            testing.ASSERT(((Integer)uba.deq()).equals(i2));
            testing.ASSERT(999 - i2 == uba.size());
            ++i2;
        }
        testing.ASSERT(this.Empty(uba));
        uba = new UBA();
        i2 = 0;
        while (i2 < 1000) {
            uba.add(i2);
            ++i2;
        }
        int index = 0;
        Iterator iterator = uba.iterator();
        while (iterator.hasNext()) {
            int i3 = (Integer)iterator.next();
            testing.ASSERT((Integer)uba.get(index) == i3);
            uba.set(index, i3 + 5);
            testing.ASSERT((Integer)uba.get(index) == i3 + 5);
            ++index;
        }
        boolean flag = true;
        try {
            uba.get(-1);
            flag = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            uba.set(-1, null);
            flag = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            uba.get(uba.size());
            flag = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            uba.set(uba.size(), null);
            flag = false;
        }
        catch (Error error) {
            // empty catch block
        }
        testing.ASSERT(flag);
        uba = new UBA();
        UBA<Integer> uba2 = new UBA<Integer>();
        testing.ASSERT(this.Empty(uba));
        testing.ASSERT(this.Empty(uba2));
        testing.ASSERT(this.equal(uba, uba2));
        uba.append(5, 7, 8, 9);
        testing.ASSERT(!this.equal(uba, uba2));
        uba2.add(5);
        testing.ASSERT(!this.equal(uba, uba2));
        uba2.append(6, 8, 9);
        testing.ASSERT(!this.equal(uba, uba2));
        uba2.set(1, 7);
        testing.ASSERT(this.equal(uba, uba2));
        testing.ASSERT(!uba.equals(null));
        uba = new UBA(8);
        uba.append(9, 7, 4);
        uba.append(3, 4, 6);
        testing.ASSERT((Integer)uba.deq() == 9);
        try {
            uba.clear(0);
            testing.ASSERT(false);
        }
        catch (Error error) {
            // empty catch block
        }
        uba.clear();
        testing.ASSERT(uba.isEmpty() && uba.size() == 0);
        try {
            uba.rem();
            testing.ASSERT(false);
        }
        catch (Error error) {
            // empty catch block
        }
        int i4 = 0;
        while (i4 < 20) {
            uba.add(i4 / 2);
            ++i4;
        }
        i4 = 19;
        while (i4 >= 0) {
            uba.delete_and_shift(i4);
            i4 -= 2;
        }
        i4 = 0;
        while (i4 < 10) {
            testing.ASSERT((Integer)uba.get(i4) == i4);
            ++i4;
        }
        uba = new UBA(10);
        uba.add(3);
        uba.add(4);
        uba.add(1);
        uba.sort();
        testing.ASSERT((Integer)uba.get(0) == 1);
        testing.ASSERT((Integer)uba.get(1) == 3);
        testing.ASSERT((Integer)uba.get(2) == 4);
    }

    private void test_HashTable() {
        int i;
        HashTable<Integer> HT = new HashTable<Integer>();
        testing.ASSERT(this.Empty(HT));
        testing.ASSERT(!HT.contains(0));
        HT.insert(0);
        testing.ASSERT(HT.contains(0));
        testing.ASSERT(!HT.isEmpty());
        testing.ASSERT(HT.size() == 1);
        HT.remove(0);
        testing.ASSERT(this.Empty(HT));
        int rep = 0;
        while (rep < 2) {
            i = 0;
            while (i < 1000) {
                HT.insert(i);
                testing.ASSERT(HT.contains(i));
                testing.ASSERT(!HT.contains(i - 1));
                testing.ASSERT(rep == 1 || HT.size() == i / 2 + 1);
                i += 2;
            }
            ++rep;
        }
        testing.ASSERT(HT.size() == 500);
        rep = 0;
        while (rep < 2) {
            i = 0;
            while (i < 1000) {
                testing.ASSERT(HT.contains(i));
                testing.ASSERT(!HT.contains(i - 1));
                HT.remove(i - 1);
                testing.ASSERT(HT.size() == 500);
                i += 2;
            }
            ++rep;
        }
        testing.ASSERT(this.equal(HT, HT.clone()));
        int i2 = 0;
        while (i2 < 1000) {
            testing.ASSERT(!HT.isEmpty());
            HT.remove(i2);
            testing.ASSERT(!HT.contains(i2));
            testing.ASSERT(HT.size() == 500 - i2 / 2 - 1);
            i2 += 2;
        }
        testing.ASSERT(this.Empty(HT));
        testing.ASSERT(!HT.remove(-8));
        HT.add(-90000);
        HT.add(-678);
        testing.ASSERT(!HT.remove(-45));
        testing.ASSERT(HT.contains(-90000));
        testing.ASSERT(HT.contains(-678));
        testing.ASSERT(HT.remove(-90000));
        testing.ASSERT(HT.remove(-678));
        testing.ASSERT(this.Empty(HT));
        HashTable<Integer> HT2 = new HashTable<Integer>();
        HT.append(56, 34, 4);
        testing.ASSERT(this.Empty(HT2));
        testing.ASSERT(!this.equal(HT, HT2));
        HT2.add(56);
        testing.ASSERT(!this.equal(HT, HT2));
        HT2.append(34, 3);
        testing.ASSERT(!this.equal(HT, HT2));
        HT2.remove(3);
        HT2.add(4);
        testing.ASSERT(this.equal(HT, HT2));
        testing.ASSERT(!HT.equals(null));
    }

    private void test_AssociativeArrays() {
        Dict dict = new Dict();
        List LS = dict.getKeys();
        testing.ASSERT(LS != null);
        testing.ASSERT(this.Empty(LS));
        List LI = dict.getValues();
        testing.ASSERT(LI != null);
        testing.ASSERT(this.Empty(LI));
        dict.insert("Bryce", 10);
        dict.insert("Summers", -6);
        testing.ASSERT(!this.Empty(dict));
        testing.ASSERT(dict.size() == 2);
        LS = dict.getKeys();
        testing.ASSERT(LS != null);
        testing.ASSERT(LS.contains("Bryce"));
        testing.ASSERT(LS.contains("Summers"));
        LI = dict.getValues();
        testing.ASSERT(LI != null);
        testing.ASSERT(LI.contains(10));
        testing.ASSERT(LI.contains(-6));
        testing.ASSERT(10 == (Integer)dict.lookup("Bryce"));
        testing.ASSERT(-6 == (Integer)dict.lookup("Summers"));
        dict.update("Bryce", 5);
        testing.ASSERT(dict.size() == 2);
        testing.ASSERT(5 == (Integer)dict.lookup("Bryce"));
        dict.remove_key("Bryce");
        dict.remove_key("Summers");
        testing.ASSERT(this.Empty(dict));
        Dict dict2 = new Dict(5);
        int i = 0;
        while (i < 1000) {
            dict.insert("" + i, i);
            ++i;
        }
        i = 999;
        while (i >= 0) {
            dict2.insert("" + i, i);
            --i;
        }
        testing.ASSERT(this.equal(dict, dict2));
        testing.ASSERT(dict.size() == 1000);
        testing.ASSERT(!this.Empty(dict));
        testing.ASSERT(this.equal(dict, dict.clone()));
        UBA vals = dict.getValues().toUBA();
        vals.sort();
        testing.ASSERT(this.isSorted((Integer[])vals.toArray()));
        testing.ASSERT(Sort.is_sorted(vals.toArray()));
        int i2 = 0;
        while (i2 < 1000) {
            testing.ASSERT((Integer)vals.get(i2) == i2);
            testing.ASSERT((Integer)dict.lookup("" + i2) == i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < 500) {
            dict.remove_key("" + i2);
            ++i2;
        }
        i2 = 500;
        while (i2 < 1000) {
            dict.remove_key("" + i2);
            ++i2;
        }
        testing.ASSERT(this.Empty(dict));
    }

    private void test_set() {
        Set<Object> set = new Set<Integer>();
        testing.ASSERT(this.Empty(set));
        set.set_add(Integer.valueOf(0));
        set.set_add(Integer.valueOf(0));
        set.set_add(Integer.valueOf(-90));
        testing.ASSERT(set.size() == 2);
        Set<Integer> set2 = new Set<Integer>(0, -90);
        testing.ASSERT(this.equal(set, set2));
        set.set_add(set);
        testing.ASSERT(set.cardinality() == 3);
        set2 = new Set<Integer>(2, 3);
        set = set.union(set2);
        testing.ASSERT(set.cardinality() == 5);
        testing.ASSERT(this.equal(set, set.clone()));
        set = set.intersection(set2);
        testing.ASSERT(set.cardinality() == 2);
        set = set.intersection(new Set());
        testing.ASSERT(this.Empty(set));
    }

    private boolean test_Trees() {
        AVL<Integer> T1 = new AVL<Integer>();
        Integer[] A = new Integer[1000];
        int i = 0;
        while (i < 1000) {
            T1.add(i);
            A[i] = i;
            ++i;
        }
        Integer[] B = (Integer[])T1.toArray();
        testing.ASSERT(this.equal(A, B));
        return true;
    }

    private boolean test_Data_Structure() {
        throw new Error("Not yet Implemented!");
    }

    private boolean test_UnionFind() {
        UnionFind<Integer> UF = new UnionFind<Integer>();
        int i = 0;
        while (i < 10) {
            UF.makeset(i);
            ++i;
        }
        UF.union(1, 2);
        Print.print(UF);
        UF.union(2, 3);
        Print.print(UF);
        UF.union(5, 4);
        Print.print(UF);
        UF.union(0, 5);
        Print.print(UF);
        UF.union(5, 2);
        Print.print(UF);
        return true;
    }

    private void test_sort_and_search() {
        int[] A = new int[]{5, 6, 3, 7, 2, 1};
        int[] B = new int[]{5, 6, 3, 7, 2, 1};
        int[] C = new int[]{5, 6, 3, 7, 2, 1};
        int[] sorted = new int[]{1, 2, 3, 5, 6, 7};
        Sort.isort(A);
        Sort.msort(B);
        Sort.qsort(C);
        testing.ASSERT(this.equal(A, sorted));
        testing.ASSERT(this.equal(B, sorted));
        A = new int[]{0};
        Sort.isort(A);
        Sort.msort(A);
        Sort.qsort(A);
        A = new int[1000];
        B = new int[1000];
        C = new int[1000];
        int i = 0;
        while (i < 1000) {
            A[i] = (int)(1000.0 * Math.random());
            B[i] = (int)(1000.0 * Math.random());
            C[i] = (int)(1000.0 * Math.random());
            ++i;
        }
        Sort.isort(A);
        Sort.msort(B);
        Sort.qsort(C);
        testing.ASSERT(this.isSorted(A));
        testing.ASSERT(this.isSorted(B));
        testing.ASSERT(this.isSorted(C));
        testing.ASSERT(Sort.is_sorted(A));
        testing.ASSERT(Sort.is_sorted(B));
        testing.ASSERT(Sort.is_sorted(C));
    }

    private void test_search() {
    }

    private void test_singleLinkedList() {
        int i;
        SingleLinkedList<Integer> L = new SingleLinkedList<Integer>();
        Integer[] A = new Integer[1000];
        int i2 = 0;
        while (i2 < 1000) {
            L.push(i2);
            A[i2] = i2;
            testing.ASSERT(L.size() == i2 + 1);
            testing.ASSERT(!L.isEmpty());
            ++i2;
        }
        Integer[] LA = (Integer[])L.toArray();
        testing.ASSERT(LA != null);
        testing.ASSERT(L.size() == 1000);
        int i3 = 999;
        while (i3 >= 0) {
            testing.ASSERT(!L.isEmpty());
            testing.ASSERT(((Integer)L.pop()).equals(i3));
            testing.ASSERT(i3 == L.size());
            --i3;
        }
        testing.ASSERT(L.isEmpty() && L.size() == 0);
        i3 = 0;
        while (i3 < 1000) {
            L.enq(i3);
            A[i3] = i3;
            testing.ASSERT((Integer)L.getFirst() == 0);
            testing.ASSERT(i3 == (Integer)L.getLast());
            testing.ASSERT(L.size() == i3 + 1);
            testing.ASSERT(!L.isEmpty());
            ++i3;
        }
        int count = 0;
        Iterator iterator = L.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            testing.ASSERT(i == count);
            ++count;
        }
        LA = (Integer[])L.toArray();
        testing.ASSERT(LA != null);
        testing.ASSERT(L.size() == 1000);
        testing.ASSERT(this.equal(LA, A));
        i = 0;
        while (i < 1000) {
            testing.ASSERT(!L.isEmpty());
            testing.ASSERT(((Integer)L.deq()).equals(i));
            testing.ASSERT(999 - i == L.size());
            ++i;
        }
        testing.ASSERT(L.isEmpty() && L.size() == 0);
        this.test_immutableLists(new SingleLinkedList<Integer>(), new SingleLinkedList<Integer>());
    }

    private void test_set(SimpleSet<Integer> S) {
        int i = 0;
        while (i < 1000) {
            testing.ASSERT(!S.contains(i));
            S.add(i);
            testing.ASSERT(S.contains(i));
            ++i;
        }
        i = 0;
        while (i < 1000) {
            testing.ASSERT(S.contains(i));
            testing.ASSERT(S.remove(i));
            testing.ASSERT(!S.contains(i));
            testing.ASSERT(!S.remove(i));
            ++i;
        }
        i = 1000;
        while (i > 0) {
            S.add(i);
            S.add(i);
            testing.ASSERT(S.remove(i));
            S.add(i);
            testing.ASSERT(S.contains(i));
            --i;
        }
        i = 1000;
        while (i > 0) {
            testing.ASSERT(S.contains(i));
            --i;
        }
        i = 1000;
        while (i > 0) {
            testing.ASSERT(S.remove(i));
            --i;
        }
    }

    private boolean equal(Integer[] A1, Integer[] A2) {
        int len = A1.length;
        if (len != A2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!A1[i].equals(A2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equal(int[] A1, int[] A2) {
        int len = A1.length;
        if (len != A2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (A1[i] != A2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equal(Data_Structure<?> A, Data_Structure<?> B) {
        return ge_ds.xequal(A, B);
    }

    private boolean isSorted(Integer[] A) {
        int len = A.length;
        if (len < 2) {
            return true;
        }
        Integer last = null;
        Integer[] integerArray = A;
        int n = A.length;
        int n2 = 0;
        while (n2 < n) {
            int i = integerArray[n2];
            if (last == null) {
                last = i;
            } else {
                if (i < last) {
                    return false;
                }
                last = i;
            }
            ++n2;
        }
        return true;
    }

    private boolean isSorted(int[] A) {
        int len = A.length;
        if (len < 2) {
            return true;
        }
        Integer last = null;
        int[] nArray = A;
        int n = A.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (last == null) {
                last = i;
            } else {
                if (i < last) {
                    return false;
                }
                last = i;
            }
            ++n2;
        }
        return true;
    }

    private boolean Empty(Data_Structure<?> D) {
        return D.isEmpty() && D.size() == 0;
    }

    private void test_fast_structures() {
        FastStack<Integer> S = new FastStack<Integer>();
        testing.ASSERT(FastStructure.isYardFull());
        testing.ASSERT(FastStructure.isYardEmpty());
        testing.ASSERT(S.isEmpty());
        FastStructure.setYardSize(1000);
        testing.ASSERT(!FastStructure.isYardFull());
        FastStructure.fillYard(-1);
        testing.ASSERT(FastStructure.isYardFull());
        int i = 0;
        while (i < 1000) {
            S.push(i);
            testing.ASSERT((Integer)S.top() == i);
            ++i;
        }
        testing.ASSERT(!FastStructure.isYardFull());
        testing.ASSERT(FastStructure.isYardEmpty());
        i = 999;
        while (i >= 0) {
            testing.ASSERT((Integer)S.pop() == i);
            --i;
        }
        testing.ASSERT(S.isEmpty());
        testing.ASSERT(FastStructure.isYardFull());
        testing.ASSERT(!FastStructure.isYardEmpty());
        FastQueue<Integer> Q = new FastQueue<Integer>();
        int i2 = 0;
        while (i2 < 1000) {
            testing.ASSERT(Q.size() == i2);
            Q.enq(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < 1000) {
            testing.ASSERT((Integer)Q.peek() == i2);
            testing.ASSERT((Integer)Q.deq() == i2);
            ++i2;
        }
        testing.ASSERT(Q.isEmpty());
        this.test_immutableLists(S, Q);
    }

    private void test_immutableLists(Stack<Integer> S, Queue<Integer> Q) {
        testing.ASSERT(S.isEmpty());
        testing.ASSERT(Q.isEmpty());
        UBA<Stack<Integer>> stacks = new UBA<Stack<Integer>>();
        int i = 0;
        while (i < 1000) {
            S = S.push_static(i);
            stacks.enq(S);
            ++i;
        }
        int repeat = 0;
        while (repeat < 2) {
            int i2 = 0;
            while (i2 < 1000) {
                S = (Stack<Integer>)stacks.get(i2);
                int k = i2;
                while (k > 0) {
                    testing.ASSERT((Integer)S.top() == k);
                    testing.ASSERT((Integer)S.pop_static().getKey() == k);
                    testing.ASSERT((Integer)S.pop_static().getKey() == k);
                    S = S.pop_static().getVal();
                    --k;
                }
                ++i2;
            }
            ++repeat;
        }
    }

    private void test_heap() {
        ArrayHeap<Integer> h1 = new ArrayHeap<Integer>();
        testing.ASSERT(h1.isEmpty());
        testing.ASSERT(h1.size() == 0);
        h1.append(1, 3, 5, 7, 9, 0, 8, 4, 6, 2);
        testing.ASSERT(!h1.isEmpty());
        testing.ASSERT(h1.size() == 10);
        int i = 0;
        while (i < 10) {
            System.out.println("Iteration i = " + i);
            System.out.println(h1);
            testing.ASSERT(h1.size() == 10 - i);
            testing.ASSERT((Integer)h1.peek_dominating() == i);
            testing.ASSERT((Integer)h1.extract_dominating() == i);
            ++i;
        }
        testing.ASSERT(h1.isEmpty());
    }
}

